	% Example 5.12 Linear-phase, half-band lowpass FIR 
	%
	% Author: 			Lars Wanhammar 2004-08-17
	% Modified by: 	 
	% Copyright:		by authors - not released for commercial use
	% Version:			1
	% Known bugs:		None
	% Report bugs to:	Wanhammar@gmail.com
	%
	clear all
	clc
	Amaxreq = 0.1;	Aminreq = 60;					% Specification
	fc = 400;	fs = 600;	fsample = 2000;
	wcT = 2*pi*fc/fsample; 	wsT = 2*pi*fs/fsample; 	% Band edges
	%	 We must have wcT + wsT = , i.e., fc + fs = fsample/2							
	dc = (10^(Amaxreq/20)-1)/(10^(Amaxreq/20)+1);	% Acceptable deviations
	ds = (dc+1)/10^(Aminreq/20);					% according to the spec.
	dmin = min(dc, ds);
	d = [dmin dmin]; 								% Symmetry requirement		
	N = L_PHASE_LP_HB_FIR_ORDER(pi-wcT, ds)			% Estimated filter order
	[h, Err] = L_PHASE_LP_HB_FIR(N, pi-wcT);
	h
	hn = h/(1+Err);								% Normalize max gain to 1	
	disp(sprintf('Err = %2.8f',Err))
	Amax = H_2_MAG((1+Err)/(1-Err)); 
	disp(sprintf('Amax = %2.6f dB', Amax))
	Amin = H_2_MAG((1+Err)/Err);
	disp(sprintf('Amin = %2.3f dB', Amin))
	wT = linspace(0, pi, 2000);			% wT axis 0 to  rad
	H = freqz(hn, 1, wT);				% Frequency response
	Mag = H_2_MAG(H);					
	PLOT_MAG_PZ_h_FIR(wT, Mag, hn, [0 wcT wsT pi], [1 1 0 0], d, 'Mag') 
	
	
